package dev.fitko.fitconnect.api.domain.model.event.authtags;

import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public class ValidatedAuthenticationTags {

    private AuthenticationTags authenticationTags;

    private boolean isValid;
    private Problem problem;
    private String errorMessage;

    public boolean causesRejection() {
        return !isValid && problem != null;
    }

    public String getErrorMessage() {
        return errorMessage != null ? problem.getDetail() + "\n" + errorMessage : problem.getDetail();
    }

    public static ValidatedAuthenticationTags fromValidTags(AuthenticationTags authenticationTags) {
        return new ValidatedAuthenticationTags(authenticationTags, true, null, null);
    }

    public static ValidatedAuthenticationTags fromInvalidTags(Problem problem, String errorMessage) {
        return new ValidatedAuthenticationTags(null, false, problem, errorMessage);
    }

    public static ValidatedAuthenticationTags fromInvalidTags(Problem problem) {
        return new ValidatedAuthenticationTags(null, false, problem, null);
    }
}
