package dev.fitko.fitconnect.api.domain.model.event.authtags;

import com.nimbusds.jose.JWEObject;
import dev.fitko.fitconnect.api.exceptions.internal.AuthenticationTagException;
import java.text.ParseException;
import java.util.Map;
import java.util.UUID;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class AuthenticationTags {

    private String metadata;
    private String data;
    private Map<UUID, String> attachments;

    public AuthenticationTags(
            final String dataAuthTag, final String metadataAuthTag, final Map<UUID, String> attachmentAuthTags) {
        this.data = dataAuthTag;
        this.metadata = metadataAuthTag;
        attachments = attachmentAuthTags;
    }

    public static AuthenticationTags fromEncryptedData(final String encryptedData, final String encryptedMetadata) {
        final String dataAuthTag = getAuthTagFromJWT(encryptedData);
        final String metadataAuthTag = getAuthTagFromJWT(encryptedMetadata);
        return new AuthenticationTags(dataAuthTag, metadataAuthTag, null);
    }

    public static String getAuthTagFromJWT(final String base64EncodedJWT) throws AuthenticationTagException {
        if (base64EncodedJWT == null) {
            return null;
        }
        try {
            return JWEObject.parse(base64EncodedJWT).getAuthTag().toString();
        } catch (final ParseException e) {
            throw new AuthenticationTagException(e.getMessage(), e);
        }
    }
}
