package dev.fitko.fitconnect.api.domain.model.event;

import java.util.UUID;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.ToString;

@Getter
@AllArgsConstructor
@ToString
public class TypeAndUUID {

    private final String type;

    private final UUID uuid;

    public static TypeAndUUID fromString(final String s) {
        if (s == null) {
            throw new IllegalArgumentException("Claim with type:uuid must not be null");
        }
        final var index = s.indexOf(':');
        // An empty type is invalid, therefore it must be min. 1 character
        if (index < 1) {
            throw new IllegalArgumentException("Format mismatch - expected type:uuid");
        }
        final var type = s.substring(0, index);
        final var uuid = UUID.fromString(s.substring(index + 1));
        return new TypeAndUUID(type, uuid);
    }
}
