package dev.fitko.fitconnect.api.domain.model.event;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.event.problems.Problem;
import java.util.Date;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@AllArgsConstructor
@NoArgsConstructor
public class Status {

    @JsonProperty("state")
    private EventState state;

    @JsonProperty("issuer")
    private String issuer;

    @JsonProperty("issuedAt")
    private Date issuedAt;

    @JsonProperty("problems")
    private List<Problem> problems;

    public static Status fromEventLogEntry(EventLogEntry eventLogEntry) {
        return new Status(
                eventLogEntry.getEvent().getState(),
                eventLogEntry.getIssuer(),
                eventLogEntry.getIssueTime(),
                eventLogEntry.getProblems());
    }
}
