package dev.fitko.fitconnect.api.domain.model.event;

import static dev.fitko.fitconnect.api.config.defaults.SchemaConfig.SCHEMA_BASE_URL;

import java.util.HashMap;
import java.util.Map;

public enum Event {
    CREATE_SUBMISSION("create-submission") {
        @Override
        public boolean hasAuthTags() {
            return false;
        }

        public EventState getState() {
            return EventState.INCOMPLETE;
        }
    },

    CREATE_REPLY("create-reply") {
        @Override
        public boolean hasAuthTags() {
            return false;
        }

        public EventState getState() {
            return EventState.INCOMPLETE;
        }
    },

    SUBMIT_SUBMISSION("submit-submission") {
        @Override
        public boolean hasAuthTags() {
            return true;
        }

        @Override
        public EventState getState() {
            return EventState.SUBMITTED;
        }
    },

    SUBMIT_REPLY("submit-reply") {
        @Override
        public boolean hasAuthTags() {
            return true;
        }

        @Override
        public EventState getState() {
            return EventState.SUBMITTED;
        }
    },

    NOTIFY_SUBMISSION("notify-submission") {
        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.NOTIFIED;
        }
    },

    NOTIFY_REPLY("notify-reply") {
        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.NOTIFIED;
        }
    },

    @Deprecated
    /**
     * @deprecated this event type is only used for reading older events
     */
    FORWARD_SUBMISSION("forward-submission") {
        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.FORWARDED;
        }
    },

    ACCEPT_SUBMISSION("accept-submission") {
        @Override
        public boolean hasAuthTags() {
            return true;
        }

        @Override
        public EventState getState() {
            return EventState.ACCEPTED;
        }
    },

    ACCEPT_REPLY("accept-reply") {
        @Override
        public boolean hasAuthTags() {
            return true;
        }

        @Override
        public EventState getState() {
            return EventState.ACCEPTED;
        }
    },

    REJECT_SUBMISSION("reject-submission") {
        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.REJECTED;
        }
    },

    REJECT_REPLY("reject-reply") {
        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.REJECTED;
        }
    },

    DELETE_SUBMISSION("delete-submission") {
        @Override
        public boolean hasAuthTags() {
            return false;
        }

        @Override
        public EventState getState() {
            return EventState.DELETED;
        }
    };

    private static final String EVENTS_SCHEMA_PATH =
            SCHEMA_BASE_URL.getSchemaUri().resolve("events/").toString();
    private static final Map<String, Event> CONSTANTS = new HashMap<>();

    static {
        for (final Event c : values()) {
            CONSTANTS.put(c.getSchemaUri(), c);
        }
    }

    private final String name;

    Event(final String name) {
        this.name = name;
    }

    public static Event fromSchemaUri(final String schemaUri) {
        return CONSTANTS.get(schemaUri);
    }

    public String getSchemaUri() {
        return EVENTS_SCHEMA_PATH + name;
    }

    public abstract boolean hasAuthTags();

    public abstract EventState getState();
}
