package dev.fitko.fitconnect.api.domain.model.destination;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Status {
    DRAFT("draft"),

    CREATED("created"),

    ACTIVE("active"),

    INACTIVE("inactive"),

    DECOMMISSIONED("decommissioned");

    private static final Map<String, Status> CONSTANTS = new HashMap<>();

    static {
        for (final Status c : values()) {
            CONSTANTS.put(c.value, c);
        }
    }

    private final String value;

    Status(final String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static Status fromValue(final String value) {
        final Status constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
        return constant;
    }
}
