package dev.fitko.fitconnect.api.domain.model.destination;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.metadata.data.SubmissionSchema;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class Service {

    @JsonProperty("identifier")
    private String identifier;

    @JsonProperty("regions")
    private Set<String> regions = new LinkedHashSet<>();

    @JsonProperty("submissionSchemas")
    private Set<SubmissionSchema> submissionSchemas = new LinkedHashSet<>();

    @JsonProperty("replyChannels")
    private DestinationReplyChannels replyChannels;
}
