package dev.fitko.fitconnect.api.domain.model.destination;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.ReplyChannel;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.UUID;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class PublicDestination {

    @JsonProperty("destinationId")
    private UUID destinationId;

    @JsonProperty("encryptionKid")
    private String encryptionKid;

    @JsonProperty("metadataVersions")
    private Set<String> metadataVersions = new LinkedHashSet<>();

    @JsonProperty("replyChannels")
    private ReplyChannel replyChannels;

    @JsonProperty("publicServices")
    private Set<Service> publicServices = new LinkedHashSet<>();

    @JsonProperty("status")
    private Status status;

    @JsonProperty("senderAccessRestricted")
    private SenderAccess senderAccessRestricted;
}
