package dev.fitko.fitconnect.api.domain.model.destination;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.callback.Callback;
import java.util.*;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class Destination {

    @JsonProperty("name")
    private String name;

    @JsonProperty("destinationId")
    private UUID destinationId;

    @JsonProperty("encryptionKid")
    private String encryptionKid;

    @JsonProperty("metadataVersions")
    private Set<String> metadataVersions = new LinkedHashSet<>();

    @JsonProperty("publicServices")
    private Set<Service> publicServices = new LinkedHashSet<>();

    @JsonProperty("status")
    private Status status;

    @JsonProperty("contactInformation")
    private ContactInformation contactInformation;

    @JsonProperty("callback")
    private Callback callback;

    @JsonProperty("senderAccessRestricted")
    private SenderAccess senderAccessRestricted;

    @JsonProperty("clientCount")
    private Integer clientCount;

    @JsonProperty("possibleNextStatus")
    private List<Status> possibleNextStatus;

    @JsonProperty("destinationSignature")
    private String destinationSignature;

    @JsonAnyGetter
    @JsonAnySetter
    @JsonIgnore
    private Map<Object, Object> additionalProperties;
}
