package dev.fitko.fitconnect.api.domain.model.destination;

import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.callback.Callback;
import dev.fitko.fitconnect.api.domain.model.jwk.ApiJwk;
import dev.fitko.fitconnect.api.domain.model.reply.replychannel.ReplyChannel;
import java.util.Set;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class CreateDestination {

    @JsonProperty("status")
    private Status status;

    @JsonProperty("name")
    private String name;

    @JsonProperty("contactInformation")
    private ContactInformation contactInformation;

    @JsonProperty("publicServices")
    private Set<Service> publicServices;

    @JsonProperty("callback")
    private Callback callback;

    @JsonProperty("encryptionKid")
    private String encryptionKid;

    @JsonProperty("encryptionPublicKey")
    private ApiJwk encryptionPublicKey;

    @JsonProperty("signingPublicKey")
    private ApiJwk signingPublicKey;

    @JsonProperty("metadataVersions")
    private Set<String> metadataVersions;

    @JsonProperty("replyChannels")
    private ReplyChannel replyChannels;
}
