package dev.fitko.fitconnect.api.domain.model.callback;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.submission.SubmissionForPickup;
import java.util.List;

/**
 * DTO for the callback event body for new-submissions.
 *
 * @see <a href="https://schema.fitko.de/fit-connect/submission-api/callbacks/new-submissions">New
 *     Submission Callback Event</a>
 */
public class NewSubmissionsCallback {

    private final String callbackType;

    private final List<SubmissionForPickup> submissions;

    @JsonCreator
    public NewSubmissionsCallback(
            @JsonProperty("type") final String callbackType,
            @JsonProperty("submissions") final List<SubmissionForPickup> submissions) {
        this.callbackType = callbackType;
        this.submissions = submissions;
    }

    public String getCallbackType() {
        return callbackType;
    }

    public List<SubmissionForPickup> getSubmissions() {
        return submissions;
    }
}
