package dev.fitko.fitconnect.api.domain.model.callback;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.reply.ReplyForPickup;
import java.util.List;

/**
 * DTO for the callback event body that announces new replies.
 *
 * @see <a href="https://schema.fitko.de/fit-connect/submission-api/callbacks/new-replies">New Replies Callback</a>
 */
public class NewRepliesCallback {

    private final String callbackType;

    private final List<ReplyForPickup> replies;

    @JsonCreator
    public NewRepliesCallback(
            @JsonProperty("type") final String callbackType,
            @JsonProperty("replies") final List<ReplyForPickup> replies) {
        this.callbackType = callbackType;
        this.replies = replies;
    }

    public String getCallbackType() {
        return callbackType;
    }

    public List<ReplyForPickup> getReplies() {
        return replies;
    }
}
