package dev.fitko.fitconnect.api.domain.model.callback;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.fitko.fitconnect.api.domain.model.reply.ReplyForPickup;
import dev.fitko.fitconnect.api.domain.model.submission.SubmissionForPickup;
import java.util.List;

/**
 * DTO for the callback event body that announces new events.
 *
 * @see <a href="https://schema.fitko.de/fit-connect/submission-api/callbacks/new-events">New Events Callback</a>
 */
public class NewEventsCallback {

    private final List<SubmissionForPickup> submissions;

    private final List<ReplyForPickup> replies;

    @JsonCreator
    public NewEventsCallback(
            @JsonProperty("submissions") final List<SubmissionForPickup> submissions,
            @JsonProperty("replies") final List<ReplyForPickup> replies) {
        this.submissions = submissions;
        this.replies = replies;
    }

    public List<SubmissionForPickup> getSubmissions() {
        return submissions;
    }

    public List<ReplyForPickup> getReplies() {
        return replies;
    }
}
