package dev.fitko.fitconnect.api.domain.model.attachment;

import java.util.UUID;
import lombok.EqualsAndHashCode;
import lombok.Getter;

@Getter
@EqualsAndHashCode
public class EncryptedAttachment {

    private final UUID attachmentId;
    private final String content;

    /**
     * Create a new encrypted attachment.
     *
     * @param attachmentId the attachmentId that matches with the announced attachmentId in the
     *     submissions metadata
     * @param content encrypted content of the attachment
     */
    public EncryptedAttachment(final UUID attachmentId, final String content) {
        this.attachmentId = attachmentId;
        this.content = content;
    }
}
