package dev.fitko.fitconnect.api.domain.model.attachment;

import static java.util.stream.Collectors.toList;

import dev.fitko.fitconnect.api.domain.model.metadata.attachment.Purpose;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import lombok.Builder;
import lombok.Getter;
import lombok.With;

@With
@Getter
@Builder
public class AttachmentPayload {
    private UUID attachmentId;
    private String hashedData;
    private String authTag;
    private String mimeType;
    private String fileName;
    private String description;
    private byte[] data;
    private String dataAsString;
    private Purpose purpose;

    @Builder.Default
    private List<Fragment> fragments = new ArrayList<>();

    /**
     * Get all ids depending on the attachment to be fragmented or not.
     *
     * <p>If the attachment IS NOT fragmented the id of the single attachment will be returned. If the
     * attachment IS fragmented all fragment-ids will be returned
     *
     * @return list of attachment/fragment ids
     */
    public List<UUID> getAllAttachmentIds() {
        if (hasFragmentedPayload()) {
            return getFragmentIds();
        } else {
            return List.of(attachmentId);
        }
    }

    /**
     * Returns fragment-ids only.
     *
     * @return list of fragment ids, empty if attachment is not fragmented
     */
    public List<UUID> getFragmentIds() {
        return getFragments().stream().map(Fragment::getFragmentId).collect(toList());
    }

    public boolean hasFragmentedPayload() {
        return !fragments.isEmpty();
    }

    public Optional<File> getFragmentsBaseFolder() {
        if (hasFragmentedPayload()) {
            return Optional.of(fragments.get(0).getFile().getParentFile());
        }
        return Optional.empty();
    }
}
