package dev.fitko.fitconnect.api.domain.limits.destination;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@AllArgsConstructor
@NoArgsConstructor
public class DestinationLimits {

    @JsonProperty("attachments")
    private DestinationAttachmentLimits attachmentLimits;

    @JsonIgnore
    public static DestinationLimits withChangeRequest(final LimitChangeRequest limitChangeRequest) {
        final Receive receivedLimits = new Receive(null, limitChangeRequest);
        final DestinationAttachmentLimits attachmentLimits = new DestinationAttachmentLimits(null, receivedLimits);
        return new DestinationLimits(attachmentLimits);
    }
}
