package dev.fitko.fitconnect.api.config.virusscan;

import java.util.Arrays;

/** Enum representing the different types of virus scanner modes. */
public enum VirusScannerMode {

    /**
     * ClamAV daemon scanner that connects to a running ClamAV daemon via TCP socket. This is the
     * recommended scanner for production use when ClamAV daemon is available.
     */
    CLAMAV_DAEMON("clamav-daemon"),

    /**
     * ClamAV process scanner that executes ClamAV as a separate process. This scanner is useful when
     * ClamAV daemon is not available or not preferred.
     */
    CLAMAV_PROCESS("clamav-process"),

    /**
     * No-op virus scanner that performs no actual scanning. This scanner is useful for testing or
     * when virus scanning is disabled.
     */
    NO_OP("no-op");

    private final String value;

    VirusScannerMode(String value) {
        this.value = value;
    }

    /**
     * Gets the string value of this scanner type.
     *
     * @return the string value
     */
    public String getValue() {
        return value;
    }

    /**
     * Converts a string value to a VirusScannerType.
     *
     * @param value the string value to convert
     * @return the corresponding VirusScannerType, or null if not found
     */
    public static VirusScannerMode fromValue(String value) {
        if (value == null) {
            return null;
        }

        return Arrays.stream(values())
                .filter(type -> type.value.equalsIgnoreCase(value))
                .findFirst()
                .orElse(null);
    }
}
