package dev.fitko.fitconnect.api.config.http;

import java.time.Duration;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.NoArgsConstructor;

@Builder
@NoArgsConstructor
@AllArgsConstructor
public class Timeouts {

    public static final Duration DEFAULT_TIMEOUT = Duration.ofSeconds(30);

    /** Read Timeout in seconds. Value 0 means no timeout at all. */
    @Builder.Default
    private int readTimeout = DEFAULT_TIMEOUT.toSecondsPart();

    /** Write Timeout in seconds. Value 0 means no timeout at all. */
    @Builder.Default
    private int writeTimeout = DEFAULT_TIMEOUT.toSecondsPart();

    /** Connection Timeout in seconds. Value 0 means no timeout at all. */
    @Builder.Default
    private int connectionTimeout = DEFAULT_TIMEOUT.toSecondsPart();

    /** Call Timeout in seconds. Value 0 means no timeout at all. */
    @Builder.Default
    private int callTimeout = DEFAULT_TIMEOUT.toSecondsPart();

    public Duration getReadTimeoutInSeconds() {
        return Duration.ofSeconds(readTimeout);
    }

    public Duration getWriteTimeoutInSeconds() {
        return Duration.ofSeconds(writeTimeout);
    }

    public Duration getConnectionTimeoutInSeconds() {
        return Duration.ofSeconds(connectionTimeout);
    }

    public Duration getCallTimeoutInSeconds() {
        return Duration.ofSeconds(callTimeout);
    }
}
