package dev.fitko.fitconnect.api.config.http;

import dev.fitko.fitconnect.api.config.defaults.RetryableStatusCodes;
import java.util.List;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class RetryConfig {

    @Builder.Default
    private boolean allowRetries = true;

    @Builder.Default
    private List<Integer> retryableStatusCodes = RetryableStatusCodes.getDefaultCodes();

    @Builder.Default
    private int maxRetryCount = 5;

    @Builder.Default
    private int initialDelayInMs = 500;
}
