package dev.fitko.fitconnect.api.config.http;

import java.net.InetSocketAddress;
import java.net.Proxy;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;

@Getter
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class ProxyConfig {

    @Builder.Default
    private String host = "";

    @Builder.Default
    private Integer port = 0;

    @Builder.Default
    private ProxyAuth basicAuth = new ProxyAuth();

    public boolean isProxySet() {
        return (port != null && port > 0) && (host != null && !host.isBlank());
    }

    public boolean hasBasicAuthentication() {
        return basicAuth.getUsername() != null && basicAuth.getPassword() != null;
    }

    public Proxy getHttpProxy() {
        return isProxySet() ? new Proxy(Proxy.Type.HTTP, new InetSocketAddress(host, port)) : Proxy.NO_PROXY;
    }
}
