package dev.fitko.fitconnect.api.config.defaults;

import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public class ZBPEnvironment {

    public static final ZBPEnvironment INT_INTERNET = new ZBPEnvironment("INT_INTERNET", "https://int.zbp.bund.de");

    public static final ZBPEnvironment INT_NDB = new ZBPEnvironment("INT_NDB", "https://int.zbp.bmi.in.bund.de");

    public static final ZBPEnvironment INT_NDB_VN =
            new ZBPEnvironment("INT_NDB_VN", "https://int.zbp.bundid.doi-de.net");

    public static final ZBPEnvironment PROD_NDB = new ZBPEnvironment("PROD_NDB", "https://prod.zbp.bmi.in.bund.de");

    public static final ZBPEnvironment PROD_NDB_VN =
            new ZBPEnvironment("PROD_NDB_VN", "https://prod.zbp.bundid.doi-de.net");

    private String name;
    private String baseUrl;

    /**
     * This flag is for INTERNAL USAGE ONLY and should be set to FALSE by default. For production
     * usage of the FIT-Connect ZBP-Adapter, the TLS/ZBP mailbox certificate is required in PEM format
     * as a cookie in the header of the HTTP request.
     */
    private boolean sendCertAsCookie;

    public ZBPEnvironment(String name, String baseUrl) {
        this.name = name;
        this.baseUrl = baseUrl;
        this.sendCertAsCookie = false;
    }
}
