package dev.fitko.fitconnect.api.config.defaults;

import dev.fitko.fitconnect.api.config.Version;
import java.net.URI;

public enum SchemaConfig {
    SCHEMA_BASE_URL(URI.create("https://schema.fitko.de/fit-connect/")),
    ZBP_ADAPTER_SCHEMA(
            URI.create("https://schema.fitko.de/fit-connect/id.bund.de/message_v6/1.0.0/zbp-message.schema.json"),
            "/zbp-adapter-schemas/zbp-message-1.0.0.schema.json"),
    SET_SCHEMA_PATH(SCHEMA_BASE_URL.schemaUri.resolve("set-payload/"), "/set-payload.schema.json"),
    METADATA_SCHEMA_PATH(SCHEMA_BASE_URL.schemaUri.resolve("metadata/"), "/metadata.schema.json"),
    DESTINATION_SCHEMA_VERSION(SCHEMA_BASE_URL.schemaUri.resolve("xzufi/destination.schema.json"));

    private final URI schemaUri;
    private final String filename;

    SchemaConfig(final URI schemaUri, String filename) {
        this.schemaUri = schemaUri;
        this.filename = filename;
    }

    SchemaConfig(final URI schemaUri) {
        this.schemaUri = schemaUri;
        filename = "";
    }

    public URI getSchemaUriForVersion(Version version) {
        return URI.create(schemaUri + version.getVersionAsString() + filename);
    }

    public URI getSchemaUri() {
        return schemaUri;
    }

    public String getFileName() {
        return filename;
    }
}
