package dev.fitko.fitconnect.api.config.defaults;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/** HTTP status codes that are eligible for retries */
public enum RetryableStatusCodes {

    // Client Side
    REQUEST_TIMEOUT(408),
    TOO_MANY_REQUESTS(429),

    // Server Side
    INTERNAL_SERVER_ERROR(500),
    BAD_GATEWAY(502),
    SERVICE_UNAVAILABLE(503),
    GATEWAY_TIMEOUT(504);

    private final int status;

    RetryableStatusCodes(int status) {
        this.status = status;
    }

    public int getStatus() {
        return status;
    }

    public static List<Integer> getDefaultCodes() {
        return Arrays.stream(values()).map(RetryableStatusCodes::getStatus).collect(Collectors.toList());
    }
}
