package dev.fitko.fitconnect.api.config.defaults;

import dev.fitko.fitconnect.api.config.Environment;
import dev.fitko.fitconnect.api.config.EnvironmentName;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.AllArgsConstructor;
import lombok.Getter;

@Getter
@AllArgsConstructor
public enum Environments {
    PROD(
            new EnvironmentName("PROD"),
            new Environment(
                    "https://auth-prod.fit-connect.fitko.net",
                    "https://routing-api-prod.fit-connect.fitko.net",
                    List.of(
                            "https://prod.fit-connect.fitko.net/submission-api",
                            "https://submission-api-prod.fit-connect.niedersachsen.de"),
                    "https://portal.auth-prod.fit-connect.fitko.net",
                    "https://prod.fit-connect.fitko.net/destination-api",
                    true,
                    false,
                    false)),

    STAGE(
            new EnvironmentName("STAGE"),
            new Environment(
                    "https://auth-refz.fit-connect.fitko.net",
                    "https://routing-api-prod.fit-connect.fitko.net",
                    List.of(
                            "https://stage.fit-connect.fitko.net/submission-api",
                            "https://submission-api-refz.fit-connect.niedersachsen.de"),
                    "https://portal.auth-refz.fit-connect.fitko.net",
                    "https://stage.fit-connect.fitko.net/destination-api",
                    true,
                    false,
                    false)),

    TEST(
            new EnvironmentName("TEST"),
            new Environment(
                    "https://auth-testing.fit-connect.fitko.dev",
                    "https://routing-api-testing.fit-connect.fitko.dev",
                    List.of(
                            "https://test.fit-connect.fitko.dev/submission-api",
                            "https://submission-api-testing.fit-connect.fitko.dev"),
                    "https://portal.auth-testing.fit-connect.fitko.dev",
                    "https://test.fit-connect.fitko.dev/destination-api",
                    true,
                    true,
                    false));

    private final EnvironmentName environmentName;
    private final Environment environment;

    public static Map<EnvironmentName, Environment> getEnvironmentsAsMap() {
        return Arrays.stream(values())
                .collect(Collectors.toMap(Environments::getEnvironmentName, Environments::getEnvironment));
    }

    public static String getAvailableEnvironmentNames() {
        return getEnvironmentsAsMap().keySet().stream()
                .map(EnvironmentName::getName)
                .collect(Collectors.joining(" | "));
    }
}
