package dev.fitko.fitconnect.api.config.chunking;

/** Represent the chunk-size as a size factor and a {@link Unit}. */
public final class ChunkSize {

    private final int size;
    private final Unit unit;

    public ChunkSize(int size) {
        this.size = size;
        this.unit = Unit.MB;
    }

    /**
     * Creates a chunk size in megabytes.
     *
     * @param sizeInMB size in MB
     * @return ChunkSize with megabyte unit
     */
    public static ChunkSize ofMB(int sizeInMB) {
        return new ChunkSize(sizeInMB);
    }

    /**
     * Gets the defined chunk size in bytes.
     *
     * @return size in bytes
     */
    public int getSizeInBytes() {
        return size * unit.getSizeInBytes();
    }

    /**
     * Gets the defined chunk size in MB.
     *
     * @return size in MB
     */
    public int getSizeInMB() {
        return size;
    }

    private enum Unit {
        BYTE(1),
        KB(BYTE.sizeInBytes << 10),
        MB(KB.sizeInBytes << 10);

        private final int sizeInBytes;

        Unit(int sizeInBytes) {
            this.sizeInBytes = sizeInBytes;
        }

        public int getSizeInBytes() {
            return sizeInBytes;
        }
    }
}
