# API Module

The API module provides the core interfaces and domain models for building FIT-Connect SDK clients. It defines the contract between the client implementations and the underlying services.

## Structure

- **api.config** - SDK-wide configuration and settings
- **api.domain** - Domain model classes and value objects
- **api.exceptions** - Use case specific exceptions
- **api.services** - Core service interfaces for authentication, encryption, validation, and REST operations

## Core Services

### FitConnectService
The main service facade that provides a unified interface for sender and subscriber operations:

#### Sender Operations
- Create and announce submissions
- Encrypt and send submissions with metadata
- Validate metadata and data
- Poll submission status
- Receive and process replies

#### Subscriber Operations
- Poll and receive submissions
- Decrypt and validate submissions
- Confirm valid transmissions
- Poll submission and reply status
- Send replies within a case

#### Router Operations
- Find areas by zip code or city
- Find destinations by Leika key and area
- Validate routing information

## Service Architecture

The service architecture follows a composition-based design with clear separation of concerns. Here's the updated service dependency diagram:

```mermaid
classDiagram
    %% Core Services
    class FitConnectService {
        +validateMetadataSchema()
        +validateSubmissionMetadata()
        +announceSubmission()
        +sendSubmission()
        +getSubmission()
        +getEventLog()
        +listCases()
        +getReply()
        +submitReply()
    }

    %% Authentication & Security
    class OAuthService {
        +getCurrentToken()
    }

    class SecurityEventService {
        +createAcceptSubmissionEvent()
        +createRejectSubmissionEvent()
    }

    %% Data Management
    class SubmissionService {
        +announceSubmission()
        +sendSubmission()
        +getSubmission()
        +pollAvailableSubmissions()
        +uploadAttachment()
    }

    class ReplyService {
        +announceReply()
        +submitReply()
        +getReply()
        +getAvailableReplies()
        +acceptReply()
        +rejectReply()
    }

    class CaseService {
        +getEventLog()
        +listCases()
        +getCase()
        +getAuthenticationTags()
        +sendEvent()
        +getStatus()
    }

    %% Routing
    class RoutingService {
        +getAreas()
        +getRoutes()
    }

    class RoutingVerificationService {
        +validateRouteDestinations()
    }

    %% Cryptography
    class CryptoService {
        +decryptString()
        +decryptBytes()
        +encryptString()
        +encryptBytes()
    }

    class MessageDigestService {
        +createHash()
        +verify()
        +calculateHMAC()
    }

    %% Validation
    class ValidationService {
        +validatePublicKey()
        +validateMetadataSchema()
        +validateIntegrity()
    }

    class SchemaProvider {
        +isAllowedSetSchema()
        +isAllowedMetadataSchema()
        +loadLatestSetSchema()
        +loadMetadataSchema()
    }

    %% Dependencies
    FitConnectService --> SubmissionService
    FitConnectService --> ReplyService
    FitConnectService --> CaseService
    FitConnectService --> CryptoService
    FitConnectService --> ValidationService
    FitConnectService --> SecurityEventService

    SubmissionService --> OAuthService
    ReplyService --> OAuthService
    CaseService --> OAuthService
    SecurityEventService --> OAuthService

    CaseService --> EventLogVerificationService
    RoutingVerificationService --> KeyService
    EventLogVerificationService --> KeyService

    CryptoService --> MessageDigestService
    ValidationService --> MessageDigestService
    ValidationService --> SchemaProvider

    EventLogVerificationService --> ValidationService
    RoutingVerificationService --> ValidationService
    SecurityEventService --> ValidationService
```

## Key Features

1. **Modular Design**
   - Services are loosely coupled
   - Clear separation of concerns
   - Easy to extend and maintain

2. **Security**
   - OAuth 2.0 authentication
   - JWE encryption for data
   - Digital signatures for events
   - HMAC for integrity verification

3. **Validation**
   - Schema validation for metadata
   - Public key validation
   - Event log verification
   - Route destination validation

4. **Error Handling**
   - Specific exceptions for different scenarios
   - Clear error messages
   - Proper error propagation

## Usage

The API module is designed to be used by the client module to implement the various FIT-Connect clients. Each client type (Sender, Subscriber, Router) uses a specific subset of the services through the `FitConnectService` facade.

For implementation details and examples, refer to the client module documentation.
