/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.ocsp;

import dev.fitko.fitconnect.jwkvalidator.x5c.CertStatus;
import dev.fitko.fitconnect.jwkvalidator.x5c.crl.CRLVerifier;
import dev.fitko.fitconnect.jwkvalidator.x5c.ocsp.OCSPCacheManager;
import dev.fitko.fitconnect.jwkvalidator.x5c.ocsp.OCSPLocationEvaluator;
import dev.fitko.fitconnect.jwkvalidator.x5c.ocsp.OCSPLocationGenerator;
import dev.fitko.fitconnect.jwkvalidator.x5c.ocsp.OCSPRequestGenerator;
import java.net.Proxy;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPVerifier {
    private static final Logger log = LoggerFactory.getLogger(OCSPVerifier.class);
    private final OCSPCacheManager cache = new OCSPCacheManager();
    private final OCSPRequestGenerator ocspRequestGenerator = new OCSPRequestGenerator();
    private final OCSPLocationGenerator ocspLocationGenerator = new OCSPLocationGenerator();
    private final OCSPLocationEvaluator ocspLocationEvaluator;

    public OCSPVerifier(Proxy proxy, CRLVerifier crlVerifier, List<String> ocspResponsSignatureAlgOIDs) {
        this.ocspLocationEvaluator = new OCSPLocationEvaluator(this.cache, crlVerifier, ocspResponsSignatureAlgOIDs, proxy);
    }

    public CertStatus checkCertStatus(X509Certificate leafCert, X509Certificate intermediateCert) {
        Optional<CertStatus> cacheEntry = this.cache.checkForEntryInCache(leafCert, intermediateCert);
        if (cacheEntry.isPresent()) {
            return cacheEntry.get();
        }
        try {
            Optional<OCSPReq> ocspReq = this.ocspRequestGenerator.generateOCSPRequest(leafCert, intermediateCert);
            List<String> locations = this.ocspLocationGenerator.getAIALocations(leafCert);
            if (ocspReq.isEmpty() || locations.isEmpty()) {
                log.error("Could not create ocspReq and/or locations for leaf {} and intermediate {}", (Object)leafCert.getSerialNumber(), (Object)intermediateCert.getSerialNumber());
                return CertStatus.UNKNOWN;
            }
            CertStatus certStatus = this.ocspLocationEvaluator.checkCertStatusForLocations(ocspReq.get(), locations, leafCert, intermediateCert);
            if (certStatus == null) {
                log.error("Cannot determine revocation status via OCSP for leafCert {} and intermediateCert {}", (Object)leafCert.getSerialNumber(), (Object)intermediateCert.getSerialNumber());
                return CertStatus.UNKNOWN;
            }
            return certStatus;
        }
        catch (Exception e) {
            log.error("OCSP validation for leaf {} and intermediate {} caused a problem", new Object[]{leafCert.getSerialNumber(), intermediateCert.getSerialNumber(), e});
            return CertStatus.UNKNOWN;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

