/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.ocsp;

import java.security.cert.X509Certificate;
import java.util.Optional;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OCSPUtils {
    private static final Logger log = LoggerFactory.getLogger(OCSPUtils.class);

    OCSPUtils() {
    }

    static Optional<byte[]> readAuthorityInformationAccessBytes(X509Certificate cert) {
        byte[] aiaExtensionValue = cert.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (aiaExtensionValue == null) {
            log.error("Certificate {} does not have Authority Information Access points", (Object)cert.getSerialNumber());
            return Optional.empty();
        }
        return Optional.of(aiaExtensionValue);
    }
}

