/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.ocsp;

import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OCSPTimestampValidator {
    private static final Logger log = LoggerFactory.getLogger(OCSPTimestampValidator.class);
    private static final Integer TIMESTAMP_TOLERANCE_IN_SECONDS = 1;

    OCSPTimestampValidator() {
    }

    Optional<BasicOCSPResp> validate(BasicOCSPResp basicResp, String serviceURL, X509Certificate leafCert) {
        SingleResp response = basicResp.getResponses()[0];
        Calendar calenderThisUpdate = Calendar.getInstance();
        calenderThisUpdate.add(13, TIMESTAMP_TOLERANCE_IN_SECONDS);
        Date curDateThisUpdate = calenderThisUpdate.getTime();
        Calendar calenderNextUpdate = Calendar.getInstance();
        calenderNextUpdate.add(13, -1 * TIMESTAMP_TOLERANCE_IN_SECONDS);
        Date curDateNextUpdate = calenderNextUpdate.getTime();
        Date thisUpdate = response.getThisUpdate();
        if (thisUpdate == null) {
            log.error("Response contains no 'thisUpdate' field for leaf cert {} and url {}", (Object)leafCert.getSerialNumber(), (Object)serviceURL);
            return Optional.empty();
        }
        Date nextUpdate = response.getNextUpdate();
        if (nextUpdate == null) {
            log.error("Response contains no 'nextUpdate' field for leaf cert {} and url {}", (Object)leafCert.getSerialNumber(), (Object)serviceURL);
            return Optional.empty();
        }
        if (curDateThisUpdate.before(thisUpdate)) {
            log.error("thisUpdate {} is after current date {} field for cert {} and url {}", new Object[]{thisUpdate, curDateThisUpdate, leafCert.getSerialNumber(), serviceURL});
            return Optional.empty();
        }
        if (curDateNextUpdate.after(nextUpdate)) {
            log.error("nextUpdate {} is before current date {} field for cert {} and url {}", new Object[]{thisUpdate, curDateNextUpdate, leafCert.getSerialNumber(), serviceURL});
            return Optional.empty();
        }
        return Optional.of(basicResp);
    }
}

