/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.ocsp;

import dev.fitko.fitconnect.jwkvalidator.x5c.ocsp.OCSPDownloadRequest;
import java.net.Proxy;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OCSPResponseManager {
    private static final Logger log = LoggerFactory.getLogger(OCSPResponseManager.class);
    private final Proxy proxy;

    OCSPResponseManager(Proxy proxy) {
        this.proxy = proxy == null ? Proxy.NO_PROXY : proxy;
    }

    Optional<BasicOCSPResp> obtainValidatedBasicOcspResponse(OCSPReq ocspReq, String serviceURL, X509Certificate leafCert) {
        return this.obtainOcspResponse(ocspReq, serviceURL, leafCert).flatMap(this::verifyOcspResponse).flatMap(ocspResp -> this.extractBasicOcspResponse((OCSPResp)ocspResp, serviceURL, leafCert)).flatMap(this::verifySingleResponseInBasicResponse).flatMap(basicResp -> this.verifyNonceExtension(ocspReq, (BasicOCSPResp)basicResp, serviceURL, leafCert));
    }

    private Optional<OCSPResp> obtainOcspResponse(OCSPReq ocspReq, String serviceURL, X509Certificate leafCert) {
        Optional<OCSPResp> response = new OCSPDownloadRequest(this.proxy).downloadResponse(serviceURL, ocspReq, leafCert);
        if (response.isEmpty()) {
            log.warn("Failed obtaining OCSP response for leaf cert {} in url {}", (Object)leafCert.getSerialNumber(), (Object)serviceURL);
            return Optional.empty();
        }
        return response;
    }

    private Optional<OCSPResp> verifyOcspResponse(OCSPResp ocspResp) {
        if (0 != ocspResp.getStatus()) {
            return Optional.empty();
        }
        return Optional.of(ocspResp);
    }

    private Optional<BasicOCSPResp> extractBasicOcspResponse(OCSPResp ocspResp, String serviceURL, X509Certificate leafCert) {
        try {
            BasicOCSPResp basicResp = (BasicOCSPResp)ocspResp.getResponseObject();
            if (basicResp == null) {
                log.warn("Invalid response for leaf cert {} in url {}", (Object)leafCert.getSerialNumber(), (Object)serviceURL);
                return Optional.empty();
            }
            return Optional.of(basicResp);
        }
        catch (OCSPException e) {
            log.warn("Invalid OCSP response object for leaf cert {} in url {}", new Object[]{leafCert.getSerialNumber(), serviceURL, e});
            return Optional.empty();
        }
    }

    private Optional<BasicOCSPResp> verifySingleResponseInBasicResponse(BasicOCSPResp basicResp) {
        SingleResp[] singleResponses = basicResp.getResponses();
        if (singleResponses == null || singleResponses.length != 1) {
            return Optional.empty();
        }
        return Optional.of(basicResp);
    }

    private Optional<BasicOCSPResp> verifyNonceExtension(OCSPReq ocspReq, BasicOCSPResp basicResp, String serviceURL, X509Certificate leafCert) {
        Optional<Extension> extension = this.obtainResponseNonceExtension(basicResp, serviceURL, leafCert);
        if (extension.isEmpty()) {
            return Optional.of(basicResp);
        }
        if (!this.responseNonceValid(ocspReq, extension.get(), serviceURL, leafCert)) {
            log.error("Invalid nonce for leaf cert {} in url {}", (Object)leafCert.getSerialNumber(), (Object)serviceURL);
            return Optional.empty();
        }
        return Optional.of(basicResp);
    }

    private Optional<Extension> obtainResponseNonceExtension(BasicOCSPResp basicResp, String serviceURL, X509Certificate leafCert) {
        if (!basicResp.hasExtensions()) {
            log.warn("OCSP response for leaf cert {} and url {} returned no extensions and therefore no nonce", (Object)leafCert.getSerialNumber(), (Object)serviceURL);
            return Optional.empty();
        }
        Extension idPkixOcspNonceResponseExtension = basicResp.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (idPkixOcspNonceResponseExtension == null) {
            log.warn("OCSP response for leaf cert {} and url {} returned no id_pkix_ocsp_nonce extension", (Object)leafCert.getSerialNumber(), (Object)serviceURL);
            return Optional.empty();
        }
        return Optional.of(idPkixOcspNonceResponseExtension);
    }

    private boolean responseNonceValid(OCSPReq ocspReq, Extension idPkixOcspNonceResponseExtension, String serviceURL, X509Certificate leafCert) {
        ASN1OctetString respNonce;
        Extension idPkixOcspNonceRequestExtension = ocspReq.getExtension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce);
        if (idPkixOcspNonceRequestExtension == null) {
            log.error("OCSP request for leaf cert {} and url {} returned no id_pkix_ocsp_nonce extension", (Object)leafCert.getSerialNumber(), (Object)serviceURL);
            return false;
        }
        ASN1OctetString reqNonce = idPkixOcspNonceRequestExtension.getExtnValue();
        if (!reqNonce.equals((ASN1Primitive)(respNonce = idPkixOcspNonceResponseExtension.getExtnValue()))) {
            log.error("Request nonce and response nonce are not equal for leaf cert {} and url {}", (Object)leafCert.getSerialNumber(), (Object)serviceURL);
            return false;
        }
        return true;
    }
}

