/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.ocsp;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OCSPRequestGenerator {
    private static final Logger log = LoggerFactory.getLogger(OCSPRequestGenerator.class);
    private final DigestCalculator digestCalculator = this.createDigestCalculator();

    private DigestCalculator createDigestCalculator() {
        try {
            return new JcaDigestCalculatorProviderBuilder().build().get(CertificateID.HASH_SHA1);
        }
        catch (OperatorCreationException e) {
            log.error("Could not create DigestCalculator instance", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    Optional<OCSPReq> generateOCSPRequest(X509Certificate leafCert, X509Certificate intermediateCert) {
        return this.generateCertificateID(leafCert, intermediateCert).flatMap(this::buildOCSPReq);
    }

    private Optional<CertificateID> generateCertificateID(X509Certificate leafCert, X509Certificate intermediateCert) {
        try {
            CertificateID certId = new CertificateID(this.digestCalculator, new X509CertificateHolder(intermediateCert.getEncoded()), leafCert.getSerialNumber());
            return Optional.of(certId);
        }
        catch (Exception e) {
            log.error("Failed generating CertificateID for leaf {} and intermediate {}", new Object[]{leafCert.getSerialNumber(), intermediateCert.getSerialNumber(), e});
            return Optional.empty();
        }
    }

    private Optional<OCSPReq> buildOCSPReq(CertificateID certificateID) {
        try {
            OCSPReqBuilder ocspReqBuilder = new OCSPReqBuilder();
            ocspReqBuilder.addRequest(certificateID);
            byte[] nonce = BigInteger.valueOf(System.currentTimeMillis()).toByteArray();
            Extension extension = new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, new DEROctetString(nonce).getEncoded());
            Extensions extensions = new Extensions(extension);
            ocspReqBuilder.setRequestExtensions(extensions);
            return Optional.of(ocspReqBuilder.build());
        }
        catch (Exception e) {
            log.error("Failed building OCSPReq from certificate {}", (Object)certificateID.getSerialNumber(), (Object)e);
            return Optional.empty();
        }
    }
}

