/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.ocsp;

import dev.fitko.fitconnect.jwkvalidator.x5c.ocsp.OCSPUtils;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.GeneralName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OCSPLocationGenerator {
    private static final Logger log = LoggerFactory.getLogger(OCSPLocationGenerator.class);

    OCSPLocationGenerator() {
    }

    List<String> getAIALocations(X509Certificate cert) {
        Optional ocspUrlList = OCSPUtils.readAuthorityInformationAccessBytes(cert).flatMap(this::convertToDEROctet).flatMap(this::convertToAuthorityInformationAccess).flatMap(this::generateListOfOcspUrls);
        if (ocspUrlList.isEmpty()) {
            log.error("Could not generate OCSP URL list from certificate {}", (Object)cert.getSerialNumber());
            return Collections.emptyList();
        }
        return (List)ocspUrlList.get();
    }

    private Optional<DEROctetString> convertToDEROctet(byte[] aiaExtensionValue) {
        Optional<DEROctetString> optional;
        ASN1InputStream asn1In = new ASN1InputStream(aiaExtensionValue);
        try {
            optional = Optional.of((DEROctetString)asn1In.readObject());
        }
        catch (Throwable throwable) {
            try {
                try {
                    asn1In.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error in ASN1InputStream while reading extension values", (Throwable)e);
                return Optional.empty();
            }
        }
        asn1In.close();
        return optional;
    }

    private Optional<AuthorityInformationAccess> convertToAuthorityInformationAccess(DEROctetString octetString) {
        Optional<AuthorityInformationAccess> optional;
        ASN1InputStream asn1In = new ASN1InputStream(octetString.getOctets());
        try {
            ASN1Sequence asn1Sequence = (ASN1Sequence)asn1In.readObject();
            optional = Optional.of(AuthorityInformationAccess.getInstance((Object)asn1Sequence));
        }
        catch (Throwable throwable) {
            try {
                try {
                    asn1In.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                log.error("Error in ASN1InputStream while reading DEROctet", (Throwable)e);
                return Optional.empty();
            }
        }
        asn1In.close();
        return optional;
    }

    private Optional<List<String>> generateListOfOcspUrls(AuthorityInformationAccess aia) {
        AccessDescription[] accessDescriptions;
        ArrayList<String> ocspUrlList = new ArrayList<String>();
        for (AccessDescription accessDescription : accessDescriptions = aia.getAccessDescriptions()) {
            GeneralName gn = accessDescription.getAccessLocation();
            if (gn.getTagNo() != 6) continue;
            DERIA5String deria5String = (DERIA5String)ASN1IA5String.getInstance((Object)gn.getName());
            ocspUrlList.add(deria5String.getString());
        }
        return Optional.of(ocspUrlList);
    }
}

