/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.ocsp;

import com.nimbusds.jose.util.Pair;
import dev.fitko.fitconnect.jwkvalidator.x5c.CertStatus;
import dev.fitko.fitconnect.jwkvalidator.x5c.crl.CRLVerifier;
import dev.fitko.fitconnect.jwkvalidator.x5c.ocsp.OCSPCacheManager;
import dev.fitko.fitconnect.jwkvalidator.x5c.ocsp.OCSPResponseManager;
import dev.fitko.fitconnect.jwkvalidator.x5c.ocsp.OCSPResponseSignatureValidator;
import dev.fitko.fitconnect.jwkvalidator.x5c.ocsp.OCSPTimestampValidator;
import java.net.Proxy;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OCSPLocationEvaluator {
    private static final Logger log = LoggerFactory.getLogger(OCSPLocationEvaluator.class);
    private final OCSPCacheManager cache;
    private final OCSPResponseManager ocspResponseManager;
    private final OCSPTimestampValidator ocspTimestampValidator;
    private final OCSPResponseSignatureValidator ocspResponseSignatureValidator;

    OCSPLocationEvaluator(OCSPCacheManager cache, CRLVerifier crlVerifier, List<String> ocspResponsSignatureAlgOIDs, Proxy proxy) {
        this.cache = cache;
        this.ocspResponseManager = new OCSPResponseManager(proxy);
        this.ocspTimestampValidator = new OCSPTimestampValidator();
        this.ocspResponseSignatureValidator = new OCSPResponseSignatureValidator(crlVerifier, ocspResponsSignatureAlgOIDs);
    }

    CertStatus checkCertStatusForLocations(OCSPReq ocspReq, List<String> locations, X509Certificate leafCert, X509Certificate intermediateCert) {
        for (String serviceURL : locations) {
            Optional optionalResult = this.ocspResponseManager.obtainValidatedBasicOcspResponse(ocspReq, serviceURL, leafCert).flatMap(basicResp -> this.ocspTimestampValidator.validate((BasicOCSPResp)basicResp, serviceURL, leafCert)).flatMap(basicResp -> this.ocspResponseSignatureValidator.validate((BasicOCSPResp)basicResp, serviceURL, leafCert, intermediateCert)).flatMap(this::convertToCertStatus);
            if (!optionalResult.isPresent()) continue;
            Pair result = (Pair)optionalResult.get();
            return this.cache.saveToCache((CertStatus)((Object)result.getLeft()), (BasicOCSPResp)result.getRight(), leafCert, intermediateCert);
        }
        log.error("No valid OCSP response for leaf cert {} from any of the following locations: {}", (Object)leafCert.getSerialNumber(), locations);
        return null;
    }

    private Optional<Pair<CertStatus, BasicOCSPResp>> convertToCertStatus(BasicOCSPResp basicResp) {
        CertificateStatus status = basicResp.getResponses()[0].getCertStatus();
        if (status == CertificateStatus.GOOD) {
            return Optional.of(Pair.of((Object)((Object)CertStatus.VALID), (Object)basicResp));
        }
        if (status instanceof RevokedStatus) {
            return Optional.of(Pair.of((Object)((Object)CertStatus.REVOKED), (Object)basicResp));
        }
        return Optional.of(Pair.of((Object)((Object)CertStatus.UNKNOWN), (Object)basicResp));
    }
}

