/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.ocsp;

import dev.fitko.fitconnect.jwkvalidator.x5c.net.RevocationDownloadRequest;
import dev.fitko.fitconnect.jwkvalidator.x5c.net.ValidResponseCodes;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.Proxy;
import java.net.SocketTimeoutException;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPDownloadRequest
extends RevocationDownloadRequest<OCSPResp> {
    private static final Logger log = LoggerFactory.getLogger(OCSPDownloadRequest.class);

    public OCSPDownloadRequest(Proxy proxy) {
        super(proxy);
    }

    public Optional<OCSPResp> downloadResponse(String serviceURL, OCSPReq request, X509Certificate leafCert) {
        if (!this.isHttpURL(serviceURL)) {
            log.error("Failed obtaining OCSP response for {}. Only http is supported", (Object)serviceURL);
            return Optional.empty();
        }
        Optional httpConnection = this.createHttpConnection(leafCert, serviceURL).flatMap(connection -> this.setHttpConnectionRequestProperties((HttpURLConnection)connection, serviceURL, leafCert)).flatMap(connection -> this.writeRequestToHttpConnection((HttpURLConnection)connection, request, leafCert, serviceURL)).flatMap(connection -> this.validateHttpConnectionResponseCode(ValidResponseCodes.HTTP, (HttpURLConnection)connection, leafCert, serviceURL));
        if (httpConnection.isEmpty()) {
            return Optional.empty();
        }
        return this.readResponseFromHttpConnection((HttpURLConnection)httpConnection.get(), leafCert, serviceURL);
    }

    private Optional<HttpURLConnection> setHttpConnectionRequestProperties(HttpURLConnection httpConnection, String serviceURL, X509Certificate leafCert) {
        try {
            httpConnection.setRequestProperty("Content-Type", "application/ocsp-request");
            httpConnection.setRequestProperty("Accept", "application/ocsp-response");
            httpConnection.setRequestMethod("POST");
            httpConnection.setDoOutput(true);
            httpConnection.setConnectTimeout(10000);
            return Optional.of(httpConnection);
        }
        catch (ProtocolException e) {
            log.error("Failed setting request method for http connection with service url {} for leaf cert {}", new Object[]{serviceURL, leafCert.getSerialNumber(), e});
            this.closeHttpConnection(httpConnection);
            return Optional.empty();
        }
    }

    private Optional<HttpURLConnection> writeRequestToHttpConnection(HttpURLConnection httpConnection, OCSPReq request, X509Certificate leafCert, String serviceURL) {
        block11: {
            Optional<HttpURLConnection> optional;
            block10: {
                OutputStream out = httpConnection.getOutputStream();
                try {
                    out.write(request.getEncoded());
                    optional = Optional.of(httpConnection);
                    if (out == null) break block10;
                }
                catch (Throwable throwable) {
                    try {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (ConnectException e) {
                        log.error("Failed connecting to service url {} for OCSP request of leaf cert {}", new Object[]{serviceURL, leafCert.getSerialNumber(), e});
                        this.closeHttpConnection(httpConnection);
                        break block11;
                    }
                    catch (SocketTimeoutException e) {
                        log.error("Failed writing OCSP request for service url {} in leaf cert {} - connection timeout", new Object[]{serviceURL, leafCert.getSerialNumber(), e});
                        this.closeHttpConnection(httpConnection);
                        break block11;
                    }
                    catch (IOException e) {
                        log.error("Failed writing OCSP request for service url {} in leaf cert {}", new Object[]{serviceURL, leafCert.getSerialNumber(), e});
                        this.closeHttpConnection(httpConnection);
                    }
                }
                out.close();
            }
            return optional;
        }
        return Optional.empty();
    }

    @Override
    protected Optional<OCSPResp> buildResponseObject(InputStream in, X509Certificate cert, String serviceURL) {
        try {
            OCSPResp response = new OCSPResp(in);
            return Optional.of(response);
        }
        catch (IOException e) {
            log.error("Failed reading OCSP response for service url {} in leaf cert {}", new Object[]{serviceURL, cert, e});
            return Optional.empty();
        }
    }
}

