/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.ocsp;

import dev.fitko.fitconnect.jwkvalidator.cache.SimpleCache;
import dev.fitko.fitconnect.jwkvalidator.cache.SimpleCacheEntry;
import dev.fitko.fitconnect.jwkvalidator.x5c.CertStatus;
import java.math.BigInteger;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Optional;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OCSPCacheManager {
    private static final Logger log = LoggerFactory.getLogger(OCSPCacheManager.class);
    private static final SimpleCache<BigInteger, CertStatus> certStatusCache = new SimpleCache("OCSP_CERTSTATUS");

    OCSPCacheManager() {
    }

    Optional<CertStatus> checkForEntryInCache(X509Certificate leafCert, X509Certificate intermediateCert) {
        Optional<SimpleCacheEntry<CertStatus>> optionalEntry = certStatusCache.getEntry(leafCert.getSerialNumber());
        if (optionalEntry.isEmpty()) {
            log.debug("[{}] - No cache entry for leafCert {} and intermediateCert {}", new Object[]{certStatusCache.getIdentifier(), leafCert.getSerialNumber(), intermediateCert.getSerialNumber()});
            return Optional.empty();
        }
        log.info("[{}] - Returning OCSP response from cache for leafCert {} and intermediateCert {}", new Object[]{certStatusCache.getIdentifier(), leafCert.getSerialNumber(), intermediateCert.getSerialNumber()});
        return Optional.of(optionalEntry.get().getValue());
    }

    CertStatus saveToCache(CertStatus certStatus, BasicOCSPResp basicResponse, X509Certificate leafCert, X509Certificate intermediateCert) {
        try {
            Instant nextUpdateDate = basicResponse.getResponses()[0].getNextUpdate().toInstant();
            certStatusCache.addEntry(leafCert.getSerialNumber(), certStatus, nextUpdateDate);
            log.info("[{}] - Saving OCSP response in cache for leafCert {} and intermediateCert {}", new Object[]{certStatusCache.getIdentifier(), leafCert.getSerialNumber(), intermediateCert.getSerialNumber()});
            return certStatus;
        }
        catch (IllegalArgumentException e) {
            log.error("[{}] - Cannot save OCSP response for leafCert {} and intermediateCert {}", new Object[]{certStatusCache.getIdentifier(), leafCert.getSerialNumber(), intermediateCert.getSerialNumber(), e});
            return null;
        }
    }
}

