/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.net;

import dev.fitko.fitconnect.jwkvalidator.x5c.net.ValidResponseCodes;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RevocationDownloadRequest<T> {
    private static final Logger log = LoggerFactory.getLogger(RevocationDownloadRequest.class);
    private final Proxy proxy;

    protected RevocationDownloadRequest(Proxy proxy) {
        this.proxy = proxy;
    }

    protected Optional<HttpURLConnection> createHttpConnection(X509Certificate cert, String serviceURL) {
        try {
            URL url = new URL(serviceURL);
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection(this.proxy);
            return Optional.of(httpConnection);
        }
        catch (MalformedURLException e) {
            log.error("Invalid source {} for certificate {}", new Object[]{serviceURL, cert.getSerialNumber(), e});
        }
        catch (IOException e) {
            log.error("Failed opening connection to source {} for certificate {}", new Object[]{serviceURL, cert.getSerialNumber(), e});
        }
        return Optional.empty();
    }

    protected Optional<HttpURLConnection> validateHttpConnectionResponseCode(ValidResponseCodes validCRLResponseCodes, HttpURLConnection httpConnection, X509Certificate cert, String serviceURL) {
        try {
            int responseCode = httpConnection.getResponseCode();
            if (!validCRLResponseCodes.contains(responseCode)) {
                log.error("Invalid response {} for connection from source {} for certificate {}", new Object[]{responseCode, serviceURL, cert.getSerialNumber()});
                this.closeHttpConnection(httpConnection);
                return Optional.empty();
            }
            return Optional.of(httpConnection);
        }
        catch (IOException e) {
            log.error("Failed obtaining response code from source {} for certificate {}", new Object[]{serviceURL, cert.getSerialNumber(), e});
            this.closeHttpConnection(httpConnection);
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Optional<T> readResponseFromHttpConnection(HttpURLConnection httpConnection, X509Certificate cert, String serviceURL) {
        Optional<T> optional;
        block9: {
            InputStream in = (InputStream)httpConnection.getContent();
            try {
                optional = this.buildResponseObject(in, cert, serviceURL);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (in == null) throw throwable;
                        try {
                            in.close();
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        log.error("Failed reading response from source {} for certificate {}", new Object[]{serviceURL, cert.getSerialNumber(), e});
                        this.closeHttpConnection(httpConnection);
                        return Optional.empty();
                    }
                }
                catch (Throwable throwable3) {
                    this.closeHttpConnection(httpConnection);
                    throw throwable3;
                }
            }
            in.close();
        }
        this.closeHttpConnection(httpConnection);
        return optional;
    }

    protected void closeHttpConnection(HttpURLConnection httpConnection) {
        httpConnection.disconnect();
    }

    protected boolean isHttpURL(String crlURL) {
        return crlURL.startsWith("http://");
    }

    protected boolean isHttpsURL(String crlURL) {
        return crlURL.startsWith("https://");
    }

    protected boolean isFtpURL(String crlURL) {
        return crlURL.startsWith("ftp://");
    }

    protected boolean isLdapURL(String crlURL) {
        return crlURL.startsWith("ldap://");
    }

    protected abstract Optional<T> buildResponseObject(InputStream var1, X509Certificate var2, String var3);
}

