/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.crl;

import dev.fitko.fitconnect.jwkvalidator.x5c.CertStatus;
import dev.fitko.fitconnect.jwkvalidator.x5c.crl.CRLCacheManager;
import dev.fitko.fitconnect.jwkvalidator.x5c.crl.CRLDistributionPointEvaluator;
import dev.fitko.fitconnect.jwkvalidator.x5c.crl.CRLDistributionPointGenerator;
import java.net.Proxy;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLVerifier {
    private static final Logger log = LoggerFactory.getLogger(CRLVerifier.class);
    private final CRLCacheManager crlCacheManager = new CRLCacheManager();
    private final CRLDistributionPointGenerator crlDistributionPointGenerator = new CRLDistributionPointGenerator();
    private final CRLDistributionPointEvaluator crlDistributionPointEvaluator;

    public CRLVerifier(Proxy proxy, List<String> crlSignatureAlgOIDs) {
        this.crlDistributionPointEvaluator = new CRLDistributionPointEvaluator(proxy, this.crlCacheManager, crlSignatureAlgOIDs);
    }

    public CertStatus checkCertStatus(X509Certificate cert, X509Certificate signingCert) {
        return this.checkCertStatus(cert, signingCert, true);
    }

    public CertStatus checkCertStatus(X509Certificate cert, X509Certificate signingCert, boolean ifNoCrlSignKeyUsageThanInvalid) {
        Optional<CertStatus> cacheEntry = this.crlCacheManager.checkForEntryInCache(cert);
        if (cacheEntry.isPresent()) {
            return cacheEntry.get();
        }
        try {
            List<DistributionPoint> crlDistPoints = this.crlDistributionPointGenerator.obtainCRLDistributionPoints(cert);
            if (crlDistPoints.isEmpty()) {
                return CertStatus.UNKNOWN;
            }
            return this.crlDistributionPointEvaluator.checkCertStatusForCrlDistPoints(cert, signingCert, crlDistPoints, ifNoCrlSignKeyUsageThanInvalid);
        }
        catch (Exception e) {
            log.error("Failed verifying CRL in certificate {}", (Object)cert.getSerialNumber(), (Object)e);
            return CertStatus.UNKNOWN;
        }
    }
}

