/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.crl;

import dev.fitko.fitconnect.jwkvalidator.x5c.net.RevocationDownloadRequest;
import dev.fitko.fitconnect.jwkvalidator.x5c.net.ValidResponseCodes;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLDownloadRequest
extends RevocationDownloadRequest<X509CRL> {
    private static final Logger log = LoggerFactory.getLogger(CRLDownloadRequest.class);

    public CRLDownloadRequest(Proxy proxy) {
        super(proxy);
    }

    public Optional<X509CRL> downloadResponse(X509Certificate cert, String serviceURL) {
        if (this.isHttpURL(serviceURL) || this.isHttpsURL(serviceURL)) {
            return this.downloadFromWeb(cert, serviceURL, ValidResponseCodes.HTTP);
        }
        if (this.isFtpURL(serviceURL)) {
            return this.downloadFromWeb(cert, serviceURL, ValidResponseCodes.FTP);
        }
        if (this.isLdapURL(serviceURL)) {
            log.debug("Cannot download CRL from source {} for certificate {} - LDAP not supported", (Object)serviceURL, (Object)cert.getSerialNumber());
            return Optional.empty();
        }
        log.error("Cannot download CRL from source {} for certificate {} - Unknown source", (Object)serviceURL, (Object)cert.getSerialNumber());
        return Optional.empty();
    }

    private Optional<X509CRL> downloadFromWeb(X509Certificate cert, String serviceUrl, ValidResponseCodes validCRLResponseCodes) {
        Optional httpConnection = this.createHttpConnection(cert, serviceUrl).flatMap(connection -> this.validateHttpConnectionResponseCode(validCRLResponseCodes, (HttpURLConnection)connection, cert, serviceUrl));
        if (httpConnection.isEmpty()) {
            return Optional.empty();
        }
        return this.readResponseFromHttpConnection((HttpURLConnection)httpConnection.get(), cert, serviceUrl);
    }

    @Override
    protected Optional<X509CRL> buildResponseObject(InputStream in, X509Certificate cert, String serviceURL) {
        try {
            X509CRL response = (X509CRL)CertificateFactory.getInstance("X.509").generateCRL(in);
            return Optional.of(response);
        }
        catch (CertificateException e) {
            log.error("Failed reading CRL response from source {} for certificate {} - no provider for X.509", new Object[]{serviceURL, cert, e});
        }
        catch (CRLException e) {
            log.error("Failed reading CRL response from source {} for certificate {}", new Object[]{serviceURL, cert, e});
        }
        return Optional.empty();
    }
}

