/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.crl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.x509.CRLDistPoint;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRLDistributionPointGenerator {
    private static final Logger log = LoggerFactory.getLogger(CRLDistributionPointGenerator.class);

    CRLDistributionPointGenerator() {
    }

    List<DistributionPoint> obtainCRLDistributionPoints(X509Certificate cert) {
        Optional distributionPoints = this.readDistributionPointBytes(cert).flatMap(this::convertToDEROctet).flatMap(this::convertToCRLDistPoint).flatMap(this::generateListOfCRLs);
        if (distributionPoints.isEmpty()) {
            log.error("Could not generate list of distribution points from certificate {}", (Object)cert.getSerialNumber());
            return Collections.emptyList();
        }
        return (List)distributionPoints.get();
    }

    private Optional<byte[]> readDistributionPointBytes(X509Certificate cert) {
        byte[] crlDpExt = cert.getExtensionValue(Extension.cRLDistributionPoints.getId());
        if (crlDpExt == null) {
            log.error("Certificate {} does not have CRL Distribution points", (Object)cert.getSerialNumber());
            return Optional.empty();
        }
        return Optional.of(crlDpExt);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<DEROctetString> convertToDEROctet(byte[] crlDpExt) {
        try (ByteArrayInputStream crlDpExtIn = new ByteArrayInputStream(crlDpExt);){
            Optional<DEROctetString> optional;
            try (ASN1InputStream asn1In = new ASN1InputStream((InputStream)crlDpExtIn);){
                ASN1Primitive asn1Primitive = asn1In.readObject();
                optional = Optional.of((DEROctetString)asn1Primitive);
            }
            return optional;
        }
        catch (Exception e) {
            log.error("Failed reading extension", (Throwable)e);
            return Optional.empty();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Optional<CRLDistPoint> convertToCRLDistPoint(DEROctetString octetString) {
        try (ByteArrayInputStream crldpExtOctetsInputStream = new ByteArrayInputStream(octetString.getOctets());){
            Optional<CRLDistPoint> optional;
            try (ASN1InputStream asnOctetInStream = new ASN1InputStream((InputStream)crldpExtOctetsInputStream);){
                ASN1Primitive derOctetObj = asnOctetInStream.readObject();
                optional = Optional.of(CRLDistPoint.getInstance((Object)derOctetObj));
            }
            return optional;
        }
        catch (Exception e) {
            log.error("Failed reading distribution point", (Throwable)e);
            return Optional.empty();
        }
    }

    private Optional<List<DistributionPoint>> generateListOfCRLs(CRLDistPoint distributionPoint) {
        ArrayList<DistributionPoint> distributionPoints = new ArrayList<DistributionPoint>();
        for (DistributionPoint v : distributionPoint.getDistributionPoints()) {
            DistributionPointName dpn = v.getDistributionPoint();
            if (!this.validDistributionPointName(dpn)) continue;
            distributionPoints.add(v);
        }
        return Optional.of(distributionPoints);
    }

    private boolean validDistributionPointName(DistributionPointName dpn) {
        return dpn != null && dpn.getType() == 0;
    }
}

