/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.crl;

import dev.fitko.fitconnect.jwkvalidator.x5c.CertStatus;
import dev.fitko.fitconnect.jwkvalidator.x5c.crl.CRLCacheManager;
import dev.fitko.fitconnect.jwkvalidator.x5c.crl.CRLDownloadManager;
import java.net.Proxy;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.x509.DistributionPoint;
import org.bouncycastle.asn1.x509.DistributionPointName;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRLDistributionPointEvaluator {
    private static final Logger log = LoggerFactory.getLogger(CRLDistributionPointEvaluator.class);
    private final CRLCacheManager crlCacheManager;
    private final CRLDownloadManager crlDownloadManager;

    CRLDistributionPointEvaluator(Proxy proxy, CRLCacheManager crlCacheManager, List<String> crlSignatureAlgOIDs) {
        this.crlCacheManager = crlCacheManager;
        this.crlDownloadManager = new CRLDownloadManager(proxy, crlSignatureAlgOIDs);
    }

    CertStatus checkCertStatusForCrlDistPoints(X509Certificate cert, X509Certificate signingCert, List<DistributionPoint> crlDistPoints, boolean ifNoCrlSignKeyUsageThanInvalid) {
        for (DistributionPoint dp : crlDistPoints) {
            List<String> crlUrls = this.extractCRLUrlsFromDistributionPoint(dp, cert);
            CertStatus certStatus = this.processCRLURLs(crlUrls, dp, cert, signingCert, ifNoCrlSignKeyUsageThanInvalid);
            if (certStatus == null) continue;
            return certStatus;
        }
        log.error("Could not obtain revokation status for cert {}", (Object)cert.getSerialNumber());
        return CertStatus.UNKNOWN;
    }

    List<String> extractCRLUrlsFromDistributionPoint(DistributionPoint dp, X509Certificate cert) {
        GeneralName[] generalNames;
        if (!this.validReasonFlagInDistributionPoint(dp, cert)) {
            return Collections.emptyList();
        }
        ArrayList<String> crlUrls = new ArrayList<String>();
        DistributionPointName dpn = dp.getDistributionPoint();
        for (GeneralName v : generalNames = GeneralNames.getInstance((Object)dpn.getName()).getNames()) {
            if (v.getTagNo() != 6) continue;
            String url = ASN1IA5String.getInstance((Object)v.getName()).getString();
            crlUrls.add(url);
        }
        return crlUrls;
    }

    private boolean validReasonFlagInDistributionPoint(DistributionPoint dp, X509Certificate cert) {
        if (dp.getReasons() != null) {
            log.warn("Distribution Point suddenly specifies a reason flag for cert {}", (Object)cert.getSerialNumber());
            return false;
        }
        return true;
    }

    private CertStatus processCRLURLs(List<String> crlUrls, DistributionPoint dp, X509Certificate cert, X509Certificate signingCert, boolean ifNoCrlSignKeyUsageThanInvalid) {
        for (String url : crlUrls) {
            X509CRL x509CRL = this.processCrlURL(url, dp, cert, signingCert, ifNoCrlSignKeyUsageThanInvalid);
            if (x509CRL == null) continue;
            return this.checkRevocationStatus(x509CRL, url, dp, cert);
        }
        return null;
    }

    private X509CRL processCrlURL(String url, DistributionPoint dp, X509Certificate cert, X509Certificate signingCert, boolean ifNoCrlSignKeyUsageThanInvalid) {
        Optional<X509CRL> optionalCachedX509CRL = this.crlCacheManager.checkForEntryInCache(url);
        if (optionalCachedX509CRL.isPresent()) {
            return optionalCachedX509CRL.get();
        }
        Optional<X509CRL> downloadedX509CRL = this.crlDownloadManager.downloadAndValidateCRL(dp, cert, signingCert, url, ifNoCrlSignKeyUsageThanInvalid);
        if (downloadedX509CRL.isEmpty()) {
            return null;
        }
        X509CRL x509CRL = downloadedX509CRL.get();
        this.crlCacheManager.saveToCache(url, x509CRL);
        return x509CRL;
    }

    private CertStatus checkRevocationStatus(X509CRL x509CRL, String url, DistributionPoint dp, X509Certificate cert) {
        if (x509CRL.isRevoked(cert)) {
            log.error("Certificate {} was revoked by distribution point {} with url {}: {}", new Object[]{cert.getSerialNumber(), dp, url, x509CRL.getExtensionValue(Extension.reasonCode.getId())});
            return this.crlCacheManager.saveToCache(CertStatus.REVOKED, x509CRL, cert);
        }
        return this.crlCacheManager.saveToCache(CertStatus.VALID, x509CRL, cert);
    }
}

