/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c.crl;

import dev.fitko.fitconnect.jwkvalidator.cache.SimpleCache;
import dev.fitko.fitconnect.jwkvalidator.cache.SimpleCacheEntry;
import dev.fitko.fitconnect.jwkvalidator.x5c.CertStatus;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRLCacheManager {
    private static final Logger log = LoggerFactory.getLogger(CRLCacheManager.class);
    private static final SimpleCache<BigInteger, CertStatus> certStatusCache = new SimpleCache("CRL_CERTSTATUS");
    private static final SimpleCache<String, X509CRL> x509CRLCache = new SimpleCache("CRL_X509CRL");

    CRLCacheManager() {
    }

    Optional<CertStatus> checkForEntryInCache(X509Certificate cert) {
        Optional<SimpleCacheEntry<CertStatus>> optionalEntry = certStatusCache.getEntry(cert.getSerialNumber());
        if (optionalEntry.isEmpty()) {
            log.debug("[{}] - No cache entry for cert {}", (Object)certStatusCache.getIdentifier(), (Object)cert.getSerialNumber());
            return Optional.empty();
        }
        log.info("[{}] - Returning CRL response from cache for cert {}", (Object)certStatusCache.getIdentifier(), (Object)cert.getSerialNumber());
        return Optional.of(optionalEntry.get().getValue());
    }

    Optional<X509CRL> checkForEntryInCache(String url) {
        Optional<SimpleCacheEntry<X509CRL>> optionalEntry = x509CRLCache.getEntry(url);
        if (optionalEntry.isEmpty()) {
            log.debug("[{}] - No cache entry for url {}", (Object)x509CRLCache.getIdentifier(), (Object)url);
            return Optional.empty();
        }
        log.info("[{}] - Returning CRL response from cache for url {}", (Object)x509CRLCache.getIdentifier(), (Object)url);
        return Optional.of(optionalEntry.get().getValue());
    }

    CertStatus saveToCache(CertStatus certStatus, X509CRL x509CRL, X509Certificate cert) {
        try {
            Instant nextUpdateDate = x509CRL.getNextUpdate().toInstant();
            certStatusCache.addEntry(cert.getSerialNumber(), certStatus, nextUpdateDate);
            log.info("[{}] - Saving CRL response in cache for cert {}", (Object)certStatusCache.getIdentifier(), (Object)cert.getSerialNumber());
            return certStatus;
        }
        catch (IllegalArgumentException e) {
            log.error("[{}] - Cannot save CRL response for cert {}", new Object[]{certStatusCache.getIdentifier(), cert.getSerialNumber(), e});
            return CertStatus.UNKNOWN;
        }
    }

    void saveToCache(String url, X509CRL x509CRL) {
        try {
            Instant nextUpdateDate = x509CRL.getNextUpdate().toInstant();
            x509CRLCache.addEntry(url, x509CRL, nextUpdateDate);
            log.info("[{}] - Saving CRL list in cache for url {}", (Object)x509CRLCache.getIdentifier(), (Object)url);
        }
        catch (IllegalArgumentException e) {
            log.error("[{}] - Cannot save CRL list for url {}", new Object[]{x509CRLCache.getIdentifier(), url, e});
        }
    }
}

