/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.x5c;

import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class X5CUtils {
    private static final Logger log = LoggerFactory.getLogger(X5CUtils.class);

    X5CUtils() {
    }

    static boolean moreThan2HoursBeforeNow(Date validationDate) {
        boolean result;
        if (validationDate == null) {
            log.debug("Validation date is null - therefore now and valid");
            return false;
        }
        Instant now = Instant.now();
        Instant validationTime = validationDate.toInstant();
        Duration difference = Duration.between(validationTime, now);
        boolean bl = result = difference.toHours() > 2L;
        if (result) {
            log.warn("ValidationDate is more than 2 hours in the past. OCSP will be skipped.");
        }
        log.debug("ValidationDate is {} before now. OCSP will be executed.", (Object)difference);
        return result;
    }
}

