/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.parameter;

import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.KeyUse;
import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.jwkvalidator.exceptions.JWKInvalidPurposeException;
import dev.fitko.fitconnect.jwkvalidator.exceptions.JWKValidationException;
import dev.fitko.fitconnect.jwkvalidator.exceptions.LogLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWKParameterValidator {
    private static final Logger log = LoggerFactory.getLogger(JWKParameterValidator.class);
    private final LogLevel logLevel;

    public JWKParameterValidator(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void validateForPurpose(RSAKey jwk, KeyOperation purpose) throws IllegalArgumentException, JWKValidationException {
        if (jwk == null) {
            throw new IllegalArgumentException("Cannot validate JWK - JWK is null");
        }
        this.hasValidKid(jwk);
        if (purpose == null) {
            throw new IllegalArgumentException("Cannot validate JWK with id " + jwk.getKeyID() + " - specified purpose is null");
        }
        this.hasValidPurpose(jwk, purpose);
        this.hasValidParameters(jwk);
    }

    public void validate(RSAKey jwk) throws IllegalArgumentException, JWKValidationException {
        if (jwk == null) {
            throw new IllegalArgumentException("Cannot validate JWK - JWK is null");
        }
        this.hasValidKid(jwk);
        this.hasValidParameters(jwk);
    }

    private void hasValidParameters(RSAKey jwk) throws JWKValidationException {
        this.hasValidAlgForKeyOps(jwk);
        this.hasValidKeyLength(jwk);
        this.hasValidUse(jwk);
    }

    private void hasValidKid(RSAKey jwk) throws JWKValidationException {
        if (jwk.getKeyID() == null || jwk.getKeyID().isBlank()) {
            throw JWKValidationException.build((JWK)jwk, log, this.logLevel, "JWK does not contain any key id", new Object[0]);
        }
        if (jwk.getKeyID().length() < 3) {
            throw JWKValidationException.build((JWK)jwk, log, this.logLevel, "JWK with id {} has a key id with invalid length", new Object[0]);
        }
    }

    private void hasValidPurpose(RSAKey jwk, KeyOperation purpose) throws JWKValidationException {
        if (jwk.getKeyOperations() == null) {
            throw JWKValidationException.build((JWK)jwk, log, this.logLevel, "JWK with id {} does not contain any purpose.", jwk.getKeyID());
        }
        if (!jwk.getKeyOperations().contains(purpose)) {
            throw JWKInvalidPurposeException.build((JWK)jwk, log, this.logLevel, "JWK with id {} does not have intended purpose {}", jwk.getKeyID(), purpose);
        }
    }

    private void hasValidAlgForKeyOps(RSAKey jwk) throws JWKValidationException {
        if (jwk.getKeyOperations() == null || jwk.getAlgorithm() == null || jwk.getKeyOperations().size() > 1) {
            throw JWKValidationException.build((JWK)jwk, log, this.logLevel, "JWK with id {} does not have right amount of KeyOps and/or no Alg", jwk.getKeyID());
        }
        boolean isVerify = jwk.getKeyOperations().contains(KeyOperation.VERIFY);
        boolean isPS512 = jwk.getAlgorithm().equals((Object)JWSAlgorithm.PS512);
        if (isVerify && !isPS512) {
            throw JWKValidationException.build((JWK)jwk, log, this.logLevel, "JWK with id {} is of type {} but has wrong Alg", jwk.getKeyID(), KeyOperation.VERIFY);
        }
        boolean isWrapKey = jwk.getKeyOperations().contains(KeyOperation.WRAP_KEY);
        boolean isRSAOAEP256 = jwk.getAlgorithm().equals((Object)JWEAlgorithm.RSA_OAEP_256);
        if (isWrapKey && !isRSAOAEP256) {
            throw JWKValidationException.build((JWK)jwk, log, this.logLevel, "JWK with id {} is of type {} but has wrong Alg", jwk.getKeyID(), KeyOperation.WRAP_KEY);
        }
    }

    private void hasValidKeyLength(RSAKey jwk) throws JWKValidationException {
        byte[] modulus = jwk.getModulus().decode();
        int length = modulus.length * 8;
        if (length < 3072) {
            throw JWKValidationException.build((JWK)jwk, log, this.logLevel, "JWK with id {} has wrong key length. Is {} but should be 3072 at least.", jwk.getKeyID(), length);
        }
    }

    private void hasValidUse(RSAKey jwk) throws JWKValidationException {
        KeyUse use = jwk.getKeyUse();
        if (use == null) {
            return;
        }
        boolean hasRightKeyOps = false;
        if (KeyUse.SIGNATURE.equals((Object)use)) {
            hasRightKeyOps = jwk.getKeyOperations().contains(KeyOperation.VERIFY);
        } else if (KeyUse.ENCRYPTION.equals((Object)use)) {
            hasRightKeyOps = jwk.getKeyOperations().contains(KeyOperation.WRAP_KEY);
        } else {
            throw JWKValidationException.build((JWK)jwk, log, this.logLevel, "Invalid key use in JWK with id {}", jwk.getKeyID());
        }
        if (!hasRightKeyOps) {
            throw JWKValidationException.build((JWK)jwk, log, this.logLevel, "JWK with id {} has invalid KeyOps {} for use {}", jwk.getKeyID(), jwk.getKeyOperations(), jwk.getKeyUse());
        }
    }
}

