/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.exceptions;

import dev.fitko.fitconnect.jwkvalidator.exceptions.LogLevel;
import org.slf4j.Logger;
import org.slf4j.helpers.MessageFormatter;

public class LogHelper {
    public static void log(Logger log, LogLevel logLevel, String logAndErrorMessage, Object ... msgArgs) {
        switch (logLevel) {
            case ERROR: {
                log.error(logAndErrorMessage, msgArgs);
                break;
            }
            case WARN: {
                log.warn(logAndErrorMessage, msgArgs);
                break;
            }
            case INFO: {
                log.info(logAndErrorMessage, msgArgs);
                break;
            }
            case DEBUG: {
                log.debug(logAndErrorMessage, msgArgs);
                break;
            }
        }
    }

    public static void log(Logger log, LogLevel logLevel, String logAndErrorMessage, Exception e, Object ... msgArgs) {
        switch (logLevel) {
            case ERROR: {
                log.error(logAndErrorMessage, (Object)msgArgs, (Object)e);
                break;
            }
            case WARN: {
                log.warn(logAndErrorMessage, (Object)msgArgs, (Object)e);
                break;
            }
            case INFO: {
                log.info(logAndErrorMessage, (Object)msgArgs, (Object)e);
                break;
            }
            case DEBUG: {
                log.debug(logAndErrorMessage, (Object)msgArgs, (Object)e);
                break;
            }
        }
    }

    public static String formatMessage(String logAndErrorMessage, Object ... msgArgs) {
        return MessageFormatter.arrayFormat((String)logAndErrorMessage, (Object[])msgArgs).getMessage();
    }

    public static String formatMessage(String logAndErrorMessage, Exception e, Object ... msgArgs) {
        return MessageFormatter.arrayFormat((String)logAndErrorMessage, (Object[])msgArgs, (Throwable)e).getMessage();
    }
}

