/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.exceptions;

import com.nimbusds.jose.jwk.JWK;
import dev.fitko.fitconnect.jwkvalidator.exceptions.LogHelper;
import dev.fitko.fitconnect.jwkvalidator.exceptions.LogLevel;
import org.slf4j.Logger;

public class JWKValidationException
extends Exception {
    private final String jwkKeyId;

    JWKValidationException(JWK jwk, String message, Throwable cause) {
        super(message, cause);
        this.jwkKeyId = jwk.getKeyID();
    }

    JWKValidationException(JWK jwk, String message) {
        super(message);
        this.jwkKeyId = jwk.getKeyID();
    }

    public static JWKValidationException build(JWK jwk, Logger log, LogLevel logLevel, String logAndErrorMessage, Object ... msgArgs) {
        LogHelper.log(log, logLevel, logAndErrorMessage, msgArgs);
        String msg = LogHelper.formatMessage(logAndErrorMessage, msgArgs);
        return new JWKValidationException(jwk, msg);
    }

    public static JWKValidationException build(JWK jwk, Logger log, LogLevel logLevel, String logAndErrorMessage, Exception e, Object ... msgArgs) {
        LogHelper.log(log, logLevel, logAndErrorMessage, e, msgArgs);
        String msg = LogHelper.formatMessage(logAndErrorMessage, e, msgArgs);
        return new JWKValidationException(jwk, msg, e);
    }
}

