/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator.cache;

import dev.fitko.fitconnect.jwkvalidator.cache.SimpleCacheEntry;
import java.time.Clock;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleCache<K, V> {
    private static final Logger log = LoggerFactory.getLogger(SimpleCache.class);
    private static final long INTERVAL_BETWEEN_CLEANS_IN_MILLIS = 3600000L;
    private static boolean cacheDeactivated = false;
    private final Map<K, SimpleCacheEntry<V>> cache = new ConcurrentHashMap<K, SimpleCacheEntry<V>>();
    private final AtomicBoolean isCleanUpRunning = new AtomicBoolean(false);
    private final Clock clock;
    private final String identifier;
    private Long nextCleanupTime;

    public SimpleCache(String identifier) {
        this(identifier, Clock.systemUTC());
    }

    SimpleCache(String identifier, Clock clock) {
        this.identifier = identifier;
        this.clock = clock;
        this.nextCleanupTime = clock.instant().toEpochMilli() + 3600000L;
    }

    static void setCacheActive(boolean b) {
        log.info("Cache active: " + !b);
        cacheDeactivated = !b;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void addEntry(K key, V value, Instant expiresAfter) throws IllegalArgumentException {
        if (cacheDeactivated) {
            this.cache.clear();
            return;
        }
        if (expiresAfter == null) {
            throw new IllegalArgumentException("[" + this.identifier + "] - Cannot add entry " + String.valueOf(key) + " to cache - expiration timestamp is null");
        }
        if (this.isInstantInPast(expiresAfter)) {
            throw new IllegalArgumentException("[" + this.identifier + "] - Cannot add entry " + String.valueOf(key) + " to cache - already expired: " + String.valueOf(expiresAfter));
        }
        this.cache.put(key, new SimpleCacheEntry<V>(value, expiresAfter));
        this.checkIfCleanUpRequired();
    }

    public Optional<SimpleCacheEntry<V>> getEntry(K key) {
        if (cacheDeactivated) {
            this.cache.clear();
            return Optional.empty();
        }
        SimpleCacheEntry<V> entry = this.cache.get(key);
        if (entry == null) {
            return Optional.empty();
        }
        if (this.isInstantInPast(entry.getExpiresAfter())) {
            this.cache.remove(key);
            return Optional.empty();
        }
        this.checkIfCleanUpRequired();
        return Optional.of(entry);
    }

    private boolean isInstantInPast(Instant instant) {
        Instant now = this.clock.instant();
        return now.isAfter(instant);
    }

    private void checkIfCleanUpRequired() {
        if (!this.isTimeForCleanUp()) {
            log.debug("Clean-up for cache '{}' not required", (Object)this.identifier);
            return;
        }
        if (!this.isCleanUpRunning.compareAndSet(false, true)) {
            log.debug("Clean-up for cache \u2019{}\u2019 required, but is already running", (Object)this.identifier);
            return;
        }
        log.info("Clean-up for cache \u2019{}\u2019 required", (Object)this.identifier);
        new Thread(this::cleanUpCache).start();
    }

    private boolean isTimeForCleanUp() {
        return this.clock.instant().toEpochMilli() >= this.nextCleanupTime;
    }

    private void cleanUpCache() {
        Instant now = this.clock.instant();
        log.info("Running clean-up for cache '{}': {}", (Object)this.identifier, (Object)now);
        boolean haveEntriesBeenRemoved = this.cache.values().removeIf(entry -> now.isAfter(entry.getExpiresAfter()));
        this.nextCleanupTime = System.currentTimeMillis() + 3600000L;
        this.isCleanUpRunning.set(false);
        log.info("Finished clean-up for cache '{}'. Removals: {}", (Object)this.identifier, (Object)haveEntriesBeenRemoved);
    }
}

