/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator;

import dev.fitko.fitconnect.jwkvalidator.JWKValidator;
import dev.fitko.fitconnect.jwkvalidator.JWKValidatorBuilder;
import dev.fitko.fitconnect.jwkvalidator.RecommendedJWKValidatorBuilderSteps;
import java.net.Proxy;
import java.security.cert.TrustAnchor;
import java.util.Date;
import java.util.List;
import java.util.Set;

public class RecommendedJWKValidatorBuilder
extends JWKValidatorBuilder
implements RecommendedJWKValidatorBuilderSteps.RecommendedJWKValidatorWithX5CValidation,
RecommendedJWKValidatorBuilderSteps.RecommendedJWKValidatorWithTrustAnchors,
RecommendedJWKValidatorBuilderSteps.RecommendedJWKValidatorCreator {
    private Proxy proxy = null;
    private Set<TrustAnchor> trustAnchors = null;
    private Date defaultValidationDate = null;

    @Override
    public RecommendedJWKValidatorBuilderSteps.RecommendedJWKValidatorWithTrustAnchors withProxy(Proxy proxy) throws IllegalArgumentException {
        RecommendedJWKValidatorBuilder.assertNotNull(proxy, "Proxy value cannot be null");
        this.proxy = proxy;
        return this;
    }

    @Override
    public RecommendedJWKValidatorBuilderSteps.RecommendedJWKValidatorWithTrustAnchors withoutProxy() {
        this.proxy = Proxy.NO_PROXY;
        return this;
    }

    @Override
    public RecommendedJWKValidatorBuilderSteps.RecommendedJWKValidatorCreator withTrustAnchors(Set<TrustAnchor> trustAnchors) throws IllegalArgumentException {
        RecommendedJWKValidatorBuilder.assertNotNullOrEmpty(trustAnchors, "TrustAnchors value cannot be null or empty");
        RecommendedJWKValidatorBuilder.assertNoNullValues(trustAnchors, "TrustAnchor values cannot be null");
        this.trustAnchors = trustAnchors;
        return this;
    }

    @Override
    public RecommendedJWKValidatorBuilderSteps.RecommendedJWKValidatorCreator withRootCertificatesAsPEM(List<String> rootCertificatesAsPEM) throws RuntimeException {
        RecommendedJWKValidatorBuilder.assertNotNullOrEmpty(rootCertificatesAsPEM, "Root certificates value cannot be null or empty");
        RecommendedJWKValidatorBuilder.assertNoNullValues(rootCertificatesAsPEM, "Root certificate values cannot be null");
        this.trustAnchors = RecommendedJWKValidatorBuilder.generateTrustAnchorsFromPEM(rootCertificatesAsPEM);
        return this;
    }

    @Override
    public RecommendedJWKValidatorBuilderSteps.RecommendedJWKValidatorCreator withDefaultValidationDateOf(Date defaultDate) {
        RecommendedJWKValidatorBuilder.assertNotNull(defaultDate, "A default date cannot be null");
        this.defaultValidationDate = defaultDate;
        return this;
    }

    @Override
    public JWKValidator build() {
        return JWKValidator.withX5CValidation(this.proxy, this.trustAnchors, this.defaultValidationDate, DEFAULT_OCSP_RESPONSE_SIGNATURE_ALGORITHMS, DEFAULT_CRL_SIGNATURE_ALGORITHMS, false, DEFAULT_ERROR_LOG_LEVEL);
    }
}

