/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator;

import dev.fitko.fitconnect.jwkvalidator.JWKValidator;
import dev.fitko.fitconnect.jwkvalidator.exceptions.LogLevel;
import java.net.Proxy;
import java.security.cert.TrustAnchor;
import java.util.Date;
import java.util.List;
import java.util.Set;

public interface JWKValidatorBuilderSteps {

    public static interface Creator {
        public JWKValidator build();
    }

    public static interface ErrorLogLevel {
        public Creator withDefaultErrorLogLevel();

        public Creator withErrorLogLevel(LogLevel var1);
    }

    public static interface X5CErrorHandling {
        public ErrorLogLevel withoutThrowingExceptions();

        public ErrorLogLevel withThrowingExceptions();
    }

    public static interface WithCRLSignatureAlgorithms {
        public X5CErrorHandling withDefaultCRLSignatureAlgorithms();

        public X5CErrorHandling withCRLSignatureAlgorithms(List<String> var1);
    }

    public static interface WithOCSPResponseSignatureAlgorithms {
        public WithCRLSignatureAlgorithms withDefaultOCSPResponseSignatureAlgorithms();

        public WithCRLSignatureAlgorithms withOCSPResponseSignatureAlgorithms(List<String> var1);
    }

    public static interface FullWithDate
    extends WithDate {
        public WithOCSPResponseSignatureAlgorithms withDefaultValidationDateOfNow();
    }

    public static interface WithDate {
        public JWKValidatorBuilderSteps withDefaultValidationDateOf(Date var1) throws IllegalArgumentException;
    }

    public static interface WithTrustAnchors {
        public WithDate withTrustAnchors(Set<TrustAnchor> var1) throws IllegalArgumentException;

        public WithDate withRootCertificatesAsPEM(List<String> var1) throws RuntimeException;
    }

    public static interface WithX5CValidation {
        public WithTrustAnchors withProxy(Proxy var1) throws IllegalArgumentException;

        public WithTrustAnchors withoutProxy();
    }
}

