/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator;

import com.nimbusds.jose.util.X509CertUtils;
import dev.fitko.fitconnect.jwkvalidator.exceptions.LogLevel;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWKValidatorBuilder {
    public static final List<String> DEFAULT_OCSP_RESPONSE_SIGNATURE_ALGORITHMS = List.of(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId());
    public static final List<String> DEFAULT_CRL_SIGNATURE_ALGORITHMS = List.of(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId());
    public static final boolean DEFAULT_IS_X5C_VALIDATION_SILENT = false;
    public static final LogLevel DEFAULT_ERROR_LOG_LEVEL = LogLevel.ERROR;
    private static final Logger log = LoggerFactory.getLogger(JWKValidatorBuilder.class);

    public static void assertNotNull(Object o, String errorMessage) {
        if (o == null) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void assertNotNullOrEmpty(Collection<?> collection, String errorMessage) {
        if (collection == null || collection.isEmpty()) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void assertNoNullValues(Collection<?> collection, String errorMessage) {
        for (Object v : collection) {
            if (v != null) continue;
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static Set<TrustAnchor> generateTrustAnchorsFromPEM(List<String> rootCertificates) {
        HashSet<TrustAnchor> trustAnchors = new HashSet<TrustAnchor>();
        for (String v : rootCertificates) {
            try {
                X509Certificate x509Cert = X509CertUtils.parse((String)v);
                TrustAnchor trustAnchor = new TrustAnchor(x509Cert, null);
                trustAnchors.add(trustAnchor);
            }
            catch (Exception e) {
                log.error("Invalid Base64 encoding in PEM {}", (Object)v, (Object)e);
                throw new RuntimeException("Invalid Base64 encoding in PEM " + v, e);
            }
        }
        return trustAnchors;
    }
}

