/*
 * Decompiled with CFR 0.152.
 */
package dev.fitko.fitconnect.jwkvalidator;

import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.KeyOperation;
import com.nimbusds.jose.jwk.RSAKey;
import dev.fitko.fitconnect.jwkvalidator.FullJWKValidatorBuilder;
import dev.fitko.fitconnect.jwkvalidator.FullJWKValidatorBuilderSteps;
import dev.fitko.fitconnect.jwkvalidator.RecommendedJWKValidatorBuilder;
import dev.fitko.fitconnect.jwkvalidator.RecommendedJWKValidatorBuilderSteps;
import dev.fitko.fitconnect.jwkvalidator.exceptions.JWKValidationException;
import dev.fitko.fitconnect.jwkvalidator.exceptions.LogHelper;
import dev.fitko.fitconnect.jwkvalidator.exceptions.LogLevel;
import dev.fitko.fitconnect.jwkvalidator.exceptions.X5CValidatorNotInitializedException;
import dev.fitko.fitconnect.jwkvalidator.parameter.JWKParameterValidator;
import dev.fitko.fitconnect.jwkvalidator.x5c.X5CValidator;
import java.net.Proxy;
import java.security.cert.TrustAnchor;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWKValidator {
    private static final Logger log = LoggerFactory.getLogger(JWKValidator.class);
    private final JWKParameterValidator jwkParameterValidator;
    private final X5CValidator x5cValidator;
    private final boolean isX5CValidationSilent;
    private final LogLevel logLevel;
    private final boolean isX5CValidationRequired;

    private JWKValidator(LogLevel logLevel) {
        this.jwkParameterValidator = new JWKParameterValidator(logLevel);
        this.x5cValidator = null;
        this.isX5CValidationSilent = true;
        this.logLevel = logLevel;
        this.isX5CValidationRequired = false;
    }

    private JWKValidator(Proxy proxy, Set<TrustAnchor> trustAnchors, Date defaultValidationDate, List<String> ocspResponseSignatureAlgorithms, List<String> crlSignatureAlgorithms, boolean isX5CValidationSilent, LogLevel logLevel) {
        this.jwkParameterValidator = new JWKParameterValidator(logLevel);
        this.x5cValidator = X5CValidator.of(proxy, trustAnchors, defaultValidationDate, ocspResponseSignatureAlgorithms, crlSignatureAlgorithms, logLevel);
        if (this.x5cValidator == null) {
            throw new IllegalStateException("X5CValidator was not initialized properly (is null)");
        }
        this.isX5CValidationSilent = isX5CValidationSilent;
        this.logLevel = logLevel;
        this.isX5CValidationRequired = true;
    }

    static JWKValidator withoutX5CValidation(LogLevel logLevel) {
        return new JWKValidator(logLevel);
    }

    static JWKValidator withX5CValidation(Proxy proxy, Set<TrustAnchor> trustAnchors, Date defaultValidationDate, List<String> ocspResponseSignatureAlgorithms, List<String> crlSignatureAlgorithms, boolean isX5CValidationSilent, LogLevel logLevel) {
        return new JWKValidator(proxy, trustAnchors, defaultValidationDate, ocspResponseSignatureAlgorithms, crlSignatureAlgorithms, isX5CValidationSilent, logLevel);
    }

    public static FullJWKValidatorBuilderSteps.JWKValidatorErrorLogLevel withoutX5CValidation() {
        return new FullJWKValidatorBuilder(false);
    }

    public static FullJWKValidatorBuilderSteps.JWKValidatorWithX5CValidation withX5CValidation() {
        return new FullJWKValidatorBuilder(true);
    }

    public static RecommendedJWKValidatorBuilderSteps.RecommendedJWKValidatorWithX5CValidation withRecommendedDefaults() {
        return new RecommendedJWKValidatorBuilder();
    }

    public void validate(RSAKey jwk, KeyOperation purpose) throws IllegalArgumentException, JWKValidationException {
        this.jwkParameterValidator.validateForPurpose(jwk, purpose);
        if (this.isX5CValidationRequired) {
            this.hasValidX5c(jwk);
        }
    }

    public void validate(RSAKey jwk, Date validationDate, KeyOperation purpose) throws IllegalArgumentException, JWKValidationException {
        this.jwkParameterValidator.validateForPurpose(jwk, purpose);
        if (this.isX5CValidationRequired) {
            this.hasValidX5c(jwk, validationDate);
        }
    }

    public void validate(RSAKey jwk) throws IllegalArgumentException, JWKValidationException {
        this.jwkParameterValidator.validate(jwk);
        if (this.isX5CValidationRequired) {
            this.hasValidX5c(jwk);
        }
    }

    public void validate(RSAKey jwk, Date validationDate) throws IllegalArgumentException, JWKValidationException {
        this.jwkParameterValidator.validate(jwk);
        if (this.isX5CValidationRequired) {
            this.hasValidX5c(jwk, validationDate);
        }
    }

    private void hasValidX5c(RSAKey jwk) throws JWKValidationException {
        this.hasValidX5c(jwk, null, false);
    }

    private void hasValidX5c(RSAKey jwk, Date validationDate) throws JWKValidationException {
        this.hasValidX5c(jwk, validationDate, true);
    }

    private void hasValidX5c(RSAKey jwk, Date validationDate, boolean useValidationDate) throws JWKValidationException {
        if (this.x5cValidator == null) {
            throw X5CValidatorNotInitializedException.build((JWK)jwk, log, this.logLevel, "JWK with id {} could not be validated. X5CValidator is not initialized.", jwk.getKeyID());
        }
        try {
            if (useValidationDate) {
                this.x5cValidator.validate(jwk, validationDate);
            } else {
                this.x5cValidator.validate(jwk);
            }
        }
        catch (Exception e) {
            if (this.isX5CValidationSilent) {
                LogHelper.log(log, this.logLevel, "Found following error with X5C chain in JWK {}: {}", e, jwk.getKeyID(), e.getMessage());
            }
            LogHelper.log(log, this.logLevel, "JWK with id {} has an invalid X5C with error", e, jwk.getKeyID());
            throw e;
        }
    }
}

